#ifndef _SYSTEM_CPP
#define _SYSTEM_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <StdIO.H>
#include <IO.H>

#include "System.H"
#include "DateTime.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void SetApplicationPriority(HANDLE hProcess, HANDLE hThread, int iPriorityClass, short iThreadPriority, bool bProcessBoost, bool bThreadBoost)
{
    if(iPriorityClass == 1) SetPriorityClass(hProcess, IDLE_PRIORITY_CLASS);
    if(iPriorityClass == 2) SetPriorityClass(hProcess, NORMAL_PRIORITY_CLASS);
    if(iPriorityClass == 3) SetPriorityClass(hProcess, HIGH_PRIORITY_CLASS);
    if(iPriorityClass == 4) SetPriorityClass(hProcess, REALTIME_PRIORITY_CLASS);

    if(iThreadPriority == 1) SetThreadPriority(hThread, THREAD_PRIORITY_IDLE);
    if(iThreadPriority == 2) SetThreadPriority(hThread, THREAD_PRIORITY_LOWEST);
    if(iThreadPriority == 3) SetThreadPriority(hThread, THREAD_PRIORITY_BELOW_NORMAL);
    if(iThreadPriority == 4) SetThreadPriority(hThread, THREAD_PRIORITY_NORMAL);
    if(iThreadPriority == 5) SetThreadPriority(hThread, THREAD_PRIORITY_ABOVE_NORMAL);
    if(iThreadPriority == 6) SetThreadPriority(hThread, THREAD_PRIORITY_HIGHEST);
    if(iThreadPriority == 7) SetThreadPriority(hThread, THREAD_PRIORITY_TIME_CRITICAL);

    if(bProcessBoost == false)
	{
		SetProcessPriorityBoost(hProcess, TRUE); //Disable
	}
	else if(bProcessBoost == true){
		SetProcessPriorityBoost(hProcess, FALSE); //Enable
	}

	if(bThreadBoost == false)
	{
		SetThreadPriorityBoost(hThread, TRUE); //Disable
	}
	else if(bThreadBoost == true){
		SetThreadPriorityBoost(hThread, FALSE); //Enable
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool FileAccess(const char *sFileName, short iMode)
{
    if(_access(sFileName, iMode) == 0)
	{
        return true;
	}

    return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD Get_FileSize(const char *sFileName)
{
    HANDLE hFileHandle = CreateFile(sFileName, 0, 0, NULL, OPEN_EXISTING, 0, NULL);
	if(hFileHandle != INVALID_HANDLE_VALUE)
	{
		DWORD dwSize = GetFileSize(hFileHandle, NULL);
		CloseHandle(hFileHandle);

		if(dwSize == HFILE_ERROR)
		{
			return (DWORD) -1;
		}
	    return dwSize;
	}
	return (DWORD) -1;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsDirectory(const char *sPath)
{
    int Attrib = GetFileAttributes(sPath);
    if(Attrib != 0xFFFFFFFF)
    {
        if(Attrib & FILE_ATTRIBUTE_DIRECTORY)
		{
            return true;
		}
    }
    return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD Get_CurrentDirectoryEx (char *sOutVal)
{
    return GetCurrentDirectory(MAX_PATH, sOutVal);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_CurrentDirectory (void)
{
    char *Name = (char *) calloc(MAX_PATH, sizeof(char));
    Get_CurrentDirectoryEx(Name);
    return Name;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD Get_TempDirectoryEx (char *sOutVal)
{
    return GetTempPath(MAX_PATH, sOutVal);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_TempDirectory (void)
{
    char *Name = (char *) calloc(MAX_PATH, sizeof(char));
    Get_TempDirectoryEx(Name);
    return Name;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD Get_WindowsDirectoryEx (char *sOutVal)
{
    return GetWindowsDirectory(sOutVal, MAX_PATH);
} 

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_WindowsDirectory (void)
{
    char *Name = (char *) calloc(MAX_PATH, sizeof(char));
    Get_WindowsDirectoryEx(Name);
    return Name;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD Get_SystemDirectoryEx (char *sOutVal)
{
    return GetSystemDirectory(sOutVal, MAX_PATH);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_SystemDirectory (void)
{
    char *Name = (char *) calloc(MAX_PATH, sizeof(char));
    Get_SystemDirectoryEx(Name);
    return Name;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Get_TimeEx (char *sOutVal)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);
    return GetTimeFormat(LOCALE_USER_DEFAULT,TIME_NOSECONDS,&ST,NULL,sOutVal,64);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_Time (void)
{
    char *TimeTemp = (char *) calloc(64, sizeof(char));
    Get_TimeEx(TimeTemp);
    return TimeTemp;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Get_LongDateEx (char *sOutVal)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);
    return GetDateFormat(LOCALE_USER_DEFAULT, DATE_LONGDATE, &ST, NULL, sOutVal, 64);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_LongDate (void)
{
    char *DateTemp = (char *) calloc(64, sizeof(char));
    Get_LongDateEx(DateTemp);
    return DateTemp;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int Get_ShortDateEx (char *sOutVal)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);
    return GetDateFormat(NULL, NULL, &ST, "MM-dd-yyyy", sOutVal, 64);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_ShortDate (void)
{
    char *DateTemp = (char *) calloc(64, sizeof(char));
    Get_ShortDateEx(DateTemp);
    return DateTemp;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Get_LocalDateTime(DWORD *dwDate, DWORD *dwTime)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);

    *dwDate = TimeToLong(ST.wHour, ST.wMinute, ST.wSecond);
    *dwTime = DateToLong(ST.wYear, ST.wMonth,  ST.wDay);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void Get_SystemDateTime(DWORD *dwDate, DWORD *dwTime)
{
    SYSTEMTIME ST;
    GetSystemTime(&ST);

    *dwDate = TimeToLong(ST.wHour, ST.wMinute, ST.wSecond);;
    *dwTime = DateToLong(ST.wYear, ST.wMonth,  ST.wDay);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL Get_MachineNameEx (char *sOutVal)
{
    DWORD SizeOfName = 255;
    return GetComputerName(sOutVal, &SizeOfName);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_MachineName (void)
{
    char *Name = (char *) calloc(255, 1);
    Get_MachineNameEx(Name);
    return Name;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL Get_UserNameEx (char *sOutVal)
{
    DWORD SizeOfName = 255;
    return GetUserName(sOutVal, &SizeOfName);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_UserName (void)
{
    char *Name = (char *) calloc(255,1);
    Get_UserNameEx(Name);
    return Name;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
void Get_OsVersionEx (char *sOutVal)
{
    DWORD dwVersion = 0;
    OSVERSIONINFO OS;
    OS.dwOSVersionInfoSize = sizeof(OS);
    dwVersion = GetVersion();

    if(GetVersionEx(&OS))
    {
        if(OS.dwPlatformId == 1)
        {
            if(OS.dwMinorVersion == 0)
                sprintf(sOutVal, "Windows 95 %d.%d (Build %d) %s", LOBYTE(LOWORD(dwVersion)), HIBYTE(LOWORD(dwVersion)), OS.dwBuildNumber & 0xFFFF, OS.szCSDVersion);
            else if(OS.dwMinorVersion == 10)
                sprintf(sOutVal, "Windows 98 %d.%d (Build %d) %s", LOBYTE(LOWORD(dwVersion)), HIBYTE(LOWORD(dwVersion)), OS.dwBuildNumber & 0xFFFF, OS.szCSDVersion);
            else if(OS.dwMinorVersion == 90)
                sprintf(sOutVal, "Windows ME %d.%d (Build %d) %s", LOBYTE(LOWORD(dwVersion)), HIBYTE(LOWORD(dwVersion)), OS.dwBuildNumber & 0xFFFF, OS.szCSDVersion);
			else {
				sprintf(sOutVal, "Windows %d.%d (Build %d) %s", LOBYTE(LOWORD(dwVersion)), HIBYTE(LOWORD(dwVersion)), OS.dwBuildNumber & 0xFFFF, OS.szCSDVersion);
			}
        }
        else if(OS.dwPlatformId == 2)
        {
            if(OS.dwMajorVersion == 3 || OS.dwMajorVersion == 4)
                sprintf(sOutVal, "Windows NT %d.%d (Build %d) %s", LOBYTE(LOWORD(dwVersion)), HIBYTE(LOWORD(dwVersion)), OS.dwBuildNumber & 0xFFFF, OS.szCSDVersion);
            else if(OS.dwMajorVersion == 5 && OS.dwMinorVersion == 0)
                sprintf(sOutVal, "Windows 2000 %d.%d (Build %d) %s", LOBYTE(LOWORD(dwVersion)), HIBYTE(LOWORD(dwVersion)), OS.dwBuildNumber & 0xFFFF, OS.szCSDVersion);
            else if(OS.dwMajorVersion == 5 && OS.dwMinorVersion == 1)
                sprintf(sOutVal, "Windows XP %d.%d (Build %d) %s", LOBYTE(LOWORD(dwVersion)), HIBYTE(LOWORD(dwVersion)), OS.dwBuildNumber & 0xFFFF, OS.szCSDVersion);
            else if(OS.dwMajorVersion == 5 && OS.dwMinorVersion == 2)
                sprintf(sOutVal, "Windows 2003 %d.%d (Build %d) %s", LOBYTE(LOWORD(dwVersion)), HIBYTE(LOWORD(dwVersion)), OS.dwBuildNumber & 0xFFFF, OS.szCSDVersion);
            else if(OS.dwMajorVersion > 5)
                sprintf(sOutVal, "Windows .NET %d.%d (Build %d) %s", LOBYTE(LOWORD(dwVersion)), HIBYTE(LOWORD(dwVersion)), OS.dwBuildNumber & 0xFFFF, OS.szCSDVersion);
			else {
				sprintf(sOutVal, "Windows %d.%d (Build %d) %s", LOBYTE(LOWORD(dwVersion)), HIBYTE(LOWORD(dwVersion)), OS.dwBuildNumber & 0xFFFF, OS.szCSDVersion);
			}
        }
        else {
			sprintf(sOutVal, "Windows %d.%d (Build %d) %s", LOBYTE(LOWORD(dwVersion)), HIBYTE(LOWORD(dwVersion)), OS.dwBuildNumber & 0xFFFF, OS.szCSDVersion);
		}
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

char * Get_OsVersion (void)
{
    char *sOutVal = (char *) calloc(255, 1);
    Get_OsVersionEx(sOutVal);
    return sOutVal;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsWinNT(void)
{
    OSVERSIONINFO osv;
    osv.dwOSVersionInfoSize = sizeof(osv);
    GetVersionEx(&osv);
    return( osv.dwPlatformId == VER_PLATFORM_WIN32_NT );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/* uFlags can be any combination of the following
EWX_FORCE
    Forces processes to terminate.
    When this flag is set, Windows does not send the messages WM_QUERYENDSESSION and WM_ENDSESSION to the
    applications currently running in the system. This can cause the applications to lose data.
    Therefore, you should only use this flag in an emergency.

EWX_LOGOFF
    Shuts down all processes running in the security context of the process that called the ExitWindowsEx function.
    Then it logs the user off.

EWX_POWEROFF
    Shuts down the system and turns off the power.
    The system must support the power-off feature.
    Windows NT/2K/XP: The calling process must have the SE_SHUTDOWN_NAME privilege.
    Windows 95/98/ME: Security privileges are not supported or required.

EWX_REBOOT
    Shuts down the system and then restarts the system.
    Windows NT/2K/XP: The calling process must have the SE_SHUTDOWN_NAME privilege.
    Windows 95/98/ME: Security privileges are not supported or required.

EWX_SHUTDOWN
    Shuts down the system to a point at which it is safe to turn off the power.
    All file buffers have been flushed to disk, and all running processes have stopped.
    Windows NT/2K/XP: The calling process must have the SE_SHUTDOWN_NAME privilege.
    Windows 95/98/ME: Security privileges are not supported or required.
*/

BOOL ResetWindowsSys(UINT uFlags)
{
    HANDLE hToken;
    TOKEN_PRIVILEGES tkp;

    OSVERSIONINFO info;
    info.dwOSVersionInfoSize = sizeof(info);
    GetVersionEx(&info);

    if(info.dwPlatformId == VER_PLATFORM_WIN32_NT && (uFlags &EWX_POWEROFF || uFlags &EWX_REBOOT || uFlags &EWX_SHUTDOWN))
    {
        if(!OpenProcessToken( GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, &hToken))
             return FALSE;

        LookupPrivilegeValue(NULL, SE_SHUTDOWN_NAME, &tkp.Privileges[0].Luid);

        tkp.PrivilegeCount = 1;
        tkp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;

        AdjustTokenPrivileges(hToken, FALSE, &tkp, 0, (PTOKEN_PRIVILEGES) NULL, 0);

        if(GetLastError() != ERROR_SUCCESS)
			return FALSE;
    }

    return ExitWindowsEx(uFlags, 0);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
